
Type Demo13Screen Extends TScreen
	
	Field border:TBorder
	Field body1:TBody
	Field body2:TBody
	Field geom1:TGeom	' the geometry we will register a collision handler with
	Field geom2:TGeom	' the geometry we will test against to flip the colliding bit
	Field boxTex:TImage
	Field boxTex2:TImage
	
	Field colliding:Int ' variable that we change when we switch from colliding to not colliding
	
	Field _firstRun:Int = True
	Method Update(delta:Float)
		If _firstRun Then
			 ScreenManager.Instance().AddScreen(TPauseScreen.Create(GetTitle(), GetDetails()))
			_firstRun = False
		EndIf
		HandleKeyboardInput()
		HandleMouseInput()
		physics.Update(delta)
	End Method
	
	Method Draw(delta:Float)
		border.Draw()
		TDrawingHelper.DrawGeom(geom1, boxTex)
		TDrawingHelper.DrawGeom(geom2, boxTex2)
		
		' draw the collision text
		SetOrigin(geom1._position.x, geom1._position.y)
		Local str:String = "Collision " + colliding
		SetColor(0, 0, 0)
		DrawText "Collision " + colliding, - TextWidth(str) / 2, - TextHeight(str) / 2
		SetOrigin(0, 0)
		SetRotation(0)
		SetColor(255, 255, 255)
		
		DrawMouseSpring()
		If physics.EnableDiagnostics Then
			view.Draw()
		End If
	End Method
	
	Method Load()
		'------------Basic Setup code for a physic scene----------------------------
		physics = TPhysicsSimulator.Create(Vector2.Create(0, 200))
		view = TPhysicsSimulatorView.Create(physics)
		
		' create the static border physic bodies
		Local center:Vector2 = Vector2.Create(TDemo.gfxWidth / 2.0, TDemo.gfxHeight / 2.0)
		Local borderWidth:Int = TDemo.gfxHeight *.05
		border = TBorder.Create(TDemo.gfxWidth, TDemo.gfxHeight, borderWidth, center)
		border.Load(physics)
		
		' create the black and white boxes
		Local boxWidth:Int = 100
		Local boxHeight:Int = 100
		body1 = TBodyFactory.CreateRectangleBody(physics, boxWidth, boxHeight, 1)
		body2 = TBodyFactory.CloneBody(physics, body1)
		
		body1.SetPosition(Vector2.Create(center.X - 200, 200))
		body2.SetPosition(Vector2.Create(center.X + 200, 200))
		
		' create the geometries for the black and white bodies
		geom1 = TGeomFactory.CreateRectangleGeom(physics, body1, boxWidth, boxHeight)
		geom2 = TGeomFactory.CreateRectangleGeom(physics, body2, boxWidth, boxHeight)
		
		' generate some textures to render these boxes with
		boxTex = TDrawingHelper.CreateRectangleTexture(boxWidth, boxHeight, TColor.White, TColor.Black)
		boxTex2 = TDrawingHelper.CreateRectangleTexture(boxWIdth, boxHeight, TColor.Black, TColor.White)
		MidHandleImage(boxTex)
		MidHandleImage(boxTex2)
		'----------------------------------------------------------------------------
		
		
		' We will register this Demo13Screen type as a listener for
		' collision events coming from geom1. SEE: SendMessage() for more details.
		geom1.AddCollisionEventListener(Self)
		
	End Method
	
	
	rem
	bbdoc: you must implement the SendMessage() method for any
	type that will be listening for collision events. When
	called you can essentially do two things:
	
	1) query the collision event arg to get
	specific info about the collision and act upon it
	
	2) cancel the collision from happening so the two objects
	pass through each other. This is done by returning a 'NULL'
	value from this method. In order for the collision to happen
	you must return a non-null value. in this case I simply return
	the original geom object to satisfy the non-null requirement.
	
	NOTE: This is may not be the best way to setup collision logic 
	between objects if you are trying to do any type of object grouping. Look into
	using Collision Categories for a more robust solution.
	end rem
	Method SendMessage:Object(sender:Object, args:Object)
		Local event:TCollisionEventArgs = TCollisionEventArgs(args)
		Local geom:TGeom = TGeom(sender)		
		If geom And event Then ' we check to make sure this is an actual collisionEvent message
		
			If event.isExiting And event.geom2 = geom2 Then	' if the 2nd geom matches our geom2 and this is the first time															
				colliding = False							' the two bodies are no longer touching, then set colliding to false.
			
			Else If event.geom2 = geom2 Then				' otherwise if the 2nd geom matches our geom2 and isExiting=false then we															
				colliding = True							' have a collision.
			End If
		End If
		Return geom	' return a non-null value to allow the collision to occur.
	End Method

	Method Unload()
		
	End Method
	
	Method HandleKeyboardInput()
		Local forceAmount:Float = 3000
		Local force:Vector2 = Vector2.Zero()
		
		If KeyDown(KEY_A) Then force.X:+- forceAmount
		If KeyDown(KEY_S) Then force.Y:+forceAmount
		If KeyDown(KEY_D) Then force.X:+forceAmount
		If KeyDown(KEY_W) Then force.Y:+- forceAmount
		body1.ApplyForce(force)
		
		Local torqueAmount:Float = 14000
		Local torque:Float = 0
		If KeyDown(KEY_LEFT) Then torque:-torqueAmount
		If KeyDown(KEY_RIGHT) Then torque:+torqueAmount
		body1.ApplyTorque(torque)
		
		If KeyHit(KEY_F1) Then
			physics.EnableDiagnostics = Not physics.EnableDiagnostics
		End If
	End Method
	
	Method OnEscapeKeyHit()
		ScreenManager.Instance().AddScreen(TPauseScreen.Create(GetTitle(), GetDetails())) 
	End Method
	
	Method GetTitle:String()
		Return "Collision Event Handling"
	End Method
	
	Method GetDetails:TStringBuilder()
		Local sb:TStringBuilder = New TStringBuilder
		sb.AppendLine("This demo shows some basic collision event handling.")
		sb.AppendLine("The white box's collision event is registered with an")
		sb.AppendLine("external object that overrides the SendMessage() method.")
		sb.AppendLine("All Blitzmax Objects have a SendMessage() method, which")
		sb.AppendLine("allows the user to implement collision handling with very")
		sb.AppendLine("little setup. View the Load() method in Demo13Screen.bmx")
		sb.AppendLine("for more details.")
		sb.AppendLine("")
		sb.AppendLine("When the two boxes collide the # in the white box turns to")
		sb.AppendLine("a number 1 and is 0 otherwise.")
		sb.AppendLine("")
		sb.AppendLine("Keyboard:")
		sb.AppendLine("  -Rotate : left and right arrows")
		sb.AppendLine("  -Move : A,S,D,W")
		sb.AppendLine("")
		sb.AppendLine("Mouse:")
		sb.AppendLine("  -Hold down left button and drag") 
		Return sb
	End Method

End Type
